/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.materials;

import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;

public class MaterialRenderInfoJson {
    @Nullable
    private final ResourceLocation texture;
    @Nullable
    private final String[] fallbacks;
    @Nullable
    private final String color;
    @Nullable
    private final Boolean skipUniqueTexture;
    private final int luminosity;
    @Nullable
    private final MaterialGeneratorJson generator;

    public boolean isSkipUniqueTexture() {
        return this.skipUniqueTexture == Boolean.TRUE;
    }

    public MaterialRenderInfoJson(@Nullable ResourceLocation texture, @Nullable String[] fallbacks, @Nullable String color, @Nullable Boolean skipUniqueTexture, int luminosity, @Nullable MaterialGeneratorJson generator) {
        this.texture = texture;
        this.fallbacks = fallbacks;
        this.color = color;
        this.skipUniqueTexture = skipUniqueTexture;
        this.luminosity = luminosity;
        this.generator = generator;
    }

    @Nullable
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Nullable
    public String[] getFallbacks() {
        return this.fallbacks;
    }

    @Nullable
    public String getColor() {
        return this.color;
    }

    public int getLuminosity() {
        return this.luminosity;
    }

    @Nullable
    public MaterialGeneratorJson getGenerator() {
        return this.generator;
    }

    public static class MaterialGeneratorJson {
        private final ISpriteTransformer transformer;
        private final Set<MaterialStatsId> supportedStats;
        protected final boolean ignoreMaterialStats;

        public MaterialGeneratorJson(MaterialGeneratorJson other) {
            this(other.transformer, other.supportedStats, other.ignoreMaterialStats);
        }

        public boolean supportStatType(MaterialStatsId statType) {
            return this.supportedStats.contains((Object)statType);
        }

        public MaterialGeneratorJson(ISpriteTransformer transformer, Set<MaterialStatsId> supportedStats, boolean ignoreMaterialStats) {
            this.transformer = transformer;
            this.supportedStats = supportedStats;
            this.ignoreMaterialStats = ignoreMaterialStats;
        }

        public ISpriteTransformer getTransformer() {
            return this.transformer;
        }
    }
}

